varying vec2 		texcoord;
uniform sampler2D 	depth;

varying vec2		VPOS;
uniform mat4 		projTM;
uniform vec3		cameraDisplace;	// camera displace in eye space

/*uniform vec2 coordScale;
uniform vec2 coordOfs;*/

vec2 getScreenPos(vec4 pos)
{
	vec4 ppos;
	//vec2 spos;
		
	// compute texture space pos
	ppos=projTM*pos;
	ppos=ppos/ppos.w;
	//spos=/*vec2(1.0)-*/ppos.xy;
	return ppos.xy;
}

vec3 getEyePos(vec2 coords)
{
	vec3 pos;
	pos.z = texture2D(depth, coords.xy).r;
	pos.xy=VPOS*-pos.z;
	return pos;
}

void main()
{
	vec3 eyepos0=getEyePos(texcoord);
	vec3 eyepos1=eyepos0+cameraDisplace;
	
	//vec2 startpos=(texcoord*coordScale) + coordOfs;
	vec2 endpos=getScreenPos(vec4(eyepos1,1.0));//(getScreenPos(vec4(eyepos1,1.0))*coordScale) + coordOfs;
	vec2 displace=endpos - getScreenPos(vec4(eyepos0,1.0));
	
	gl_FragColor.xy=displace;
}
